/*
						A Simple Binary Genetic Algorithm (Binary SGA)
 						for solving the Mastermind Game
						Created by Stratos Georgopoulos

  based on the algorithm presented in the book:
  Michalewicz, Z., "Genetic Algorithms + Data Structures = Evolution Programs",
  Springer-Verlag, 3rd edition, 1996.

  			  --------------- SGA_Mastermind.H  Header File ---------------
*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include <time.h>

#define frand_ab() (2*((double) rand() / RAND_MAX)-1) /* a random real number between -1 and 1 */
#define frand() ((double) rand()/RAND_MAX) /* a random real number between 0 and 1 */


#define TRUE            1
#define FALSE           0
/* Problem Parameters */
#define POPSIZE         30     /* Population size (number of chromosomes in a population)*/
#define MAXGENS         1000   /* Maximum number of generations   */
#define NGENES          4      /* Number of genes in a chromosome */
#define NCOLORS			6	   /* Number of differnt colors 	  */
#define PXOVER          0.2    /* Probability of crossover        */
#define PMUTATION       0.05    /* Probability of mutation	      */

int Generation, /* Curent Generation number                */
    Best;       /* The Best genotype in the population     */

int Guess_Vector[NGENES] = {1,0,4,2}; /* the vector to guess for the mastermind */


struct genotype                 /* Each genotype is a member of      */
{                               /* the population                    */

	int		Gene[NGENES]; 		/* A string of variables makes a genotype */
	double 	Fitness,            /* The genotype's fitness            */
			RFitness,           /* The relative fitness              */
	    	CFitness,           /* The cumulative fitness            */
	    	Selection_Prob,     /* The probability of a selection    */
	    	Cumulative_Prob;    /* The cumulative probability        */

	int		Survivor, 	      	/* Flag for selection procedure      */
			Mate,         	 	/* Flag for Crossover procedure      */
			Mutate;        		/* Flag for Mutation procedure       */
};

struct genotype Population[POPSIZE+1]; /* The population of genotypes */
struct genotype Best_Individual;

/* Random Number Generators */
double RandVal(double,double); 	/* generate a real in a given range */
int IRand0N(int);
int IRand(int, int); 			/* generate an integer in a given range */

/* vector manipulation functions */
int belongs_into(int, int*, int);	/* searches if a given integer belongs into a given vector */

/* GA function prototypes */
void initialize(void);
void evaluate(int*);
void copy_genotypes(struct genotype*, struct genotype*);
void copy_population(struct genotype old_pop[POPSIZE+1], struct genotype new_pop[POPSIZE+1]);
void RouletteWheelSelection(void);
void crossover(void);
void mutate(void);
void report(FILE *);


